% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_eset}
\alias{add_eset}
\title{Method to add an \code{eSet} to \code{MultiDataSet}.}
\usage{
add_eset(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  sample.tables = NULL,
  feature.tables = NULL,
  warnings = TRUE,
  overwrite = FALSE,
  GRanges
)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{set}{Object derived from \code{eSet} to be used to fill the slot.}

\item{dataset.type}{Character with the type of data of the omic set (e.g. expression, methylation...)}

\item{dataset.name}{Character with the specific name for this set (NULL by default). It is useful when there 
are several sets of the same type (e.g. multiple expression assays)}

\item{sample.tables}{Character with the names of the slots with sample data besides phenoData.}

\item{feature.tables}{Character with the names of the slots with feature data besides featureData.}

\item{warnings}{Logical to indicate if warnings will be displayed.}

\item{overwrite}{Logical to indicate if the set stored in the slot will be overwritten.}

\item{GRanges}{\code{GenomicRanges} to be included in rowRanges slot.}
}
\value{
A new \code{MultiDataSet} with a slot filled.
}
\description{
This method adds or overwrites a slot of a \code{MultiDataSet} with the content 
of the given \code{eSet}.
}
\examples{
multi <- createMultiDataSet()
eset <- new("ExpressionSet", exprs = matrix(runif(10), 5))
multi <- add_eset(multi, eset, "exampledata", GRanges = NA)
}
\seealso{
\code{\link{add_methy}}, \code{\link{add_genexp}}, \code{\link{add_rnaseq}}, \code{\link{add_snps}}
}
