% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMbac.R
\name{createMbac}
\alias{createMbac}
\title{createMbac}
\usage{
createMbac(inputOmics, batchFactor = NULL, experimentalDesign, omicNames,
  commonOmic = NULL)
}
\arguments{
\item{inputOmics}{A list containing all the matrices or data.frame objects to be analysed. MultiAssayExperiment objects can alternatively be provided.}

\item{batchFactor}{Either a vector or a factor indicating the batch were each input matrix belongs to (i.e. study, lab, time point, etc.). If NULL (default) no batch is considered and just ARSyNbac noise reduction mode could be applied.}

\item{experimentalDesign}{A list with as many elements as batches. Each element can be a factor, a character vector or a data.frame indicating the experimental conditions for each sample in that batch. When being a data.frame with more than one column (multi-factorial experimental designs), the different columns will be combined into a single one to be used by MultiBaC or ARSyNbac. In any case, the experimental setting must be the same for all batches. In addition, the names of the elements in this list must be the same as declared in batches argument. If not (or if NULL), names are forced to be the same in as in batches argument and in the same order.}

\item{omicNames}{Vector of names for each input matrix. The common omic is required to have the same name across batches.}

\item{commonOmic}{Name of the common omic between the batches. It must be one of the names in omicNames argument. If NULL (default), the omic name which is common to all batches is selected as commonOmic.}
}
\value{
Custom mbac object. Elements in a mbac object:
\enumerate{
    \item ListOfBatches: A list of MultiAssayExperiment objects (one per batch).
    \item commonOmic Name of the common omic between batches.
}
}
\description{
This function creates a list object to be used by MultiBaC function from a set of matrix R objects.
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"),
                       commonOmic = "RNA")

}
