% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_calculateMetrics_from_Spectra.R
\name{calculateMetricsFromMsExperiment}
\alias{calculateMetricsFromMsExperiment}
\title{Calculate QC metrics from a MsExperiment object}
\usage{
calculateMetricsFromMsExperiment(
  msexp,
  metrics = qualityMetrics(msexp),
  filterEmptySpectra = FALSE,
  ...,
  BPPARAM = bpparam()
)
}
\arguments{
\item{msexp}{\code{MsExperiment} object}

\item{metrics}{\code{character} specifying the quality metrics to be 
calculated on \code{msexp}}

\item{filterEmptySpectra}{\code{logical(1)} specifying if empty entries and
entries with intensity zero of the \code{Spectra} object will be removed}

\item{...}{arguments passed to the quality metrics functions defined in 
\code{metrics}}

\item{BPPARAM}{Parallel processing setup. Defaults to \code{BPPARAM = bpparam()}.
See [bpparam()] for details on parallel processing with \code{BiocParallel}.}
}
\value{
\code{data.frame} containing in the columns the metrics for the 
different spectra (in rows)
}
\description{
The function \code{calculateMetricsFromMsExperiment} calculates quality 
metrics from a \code{MsExperiment} object. Each spectra in the 
\code{msexp} object should refer to one mzML file/to one sample.
}
\details{
The metrics are defined by the argument \code{metrics}. Further arguments 
passed to the quality metric functions can be specified by the \code{params}
argument. \code{params} can contain named entries which are matched against
the formal arguments of the quality metric functions.

Setting the argument \code{filterEmptySpectra} to \code{TRUE} will remove
zero-length entries, zero-intensity entries, and entries with 
intensities that are \code{Inf} from the \code{Spectra} object.
}
\examples{
library(msdata)
library(MsExperiment)
library(S4Vectors)

msexp <- MsExperiment()
sd <- DataFrame(sample_id = c("QC1", "QC2"),
    sample_name = c("QC Pool", "QC Pool"), injection_idx = c(1, 3))
sampleData(msexp) <- sd

## define file names containing spectra data for the samples and
## add them, along with other arbitrary files to the experiment
fls <- dir(system.file("sciex", package = "msdata"), full.names = TRUE)
experimentFiles(msexp) <- MsExperimentFiles(
    mzML_files = fls,
    annotations = "internal_standards.txt")
## link samples to data files: first sample to first file in "mzML_files",
## second sample to second file in "mzML_files"
msexp <- linkSampleData(msexp, with = "experimentFiles.mzML_files",
    sampleIndex = c(1, 2), withIndex = c(1, 2))
msexp <- linkSampleData(msexp, with = "experimentFiles.annotations",
     sampleIndex = c(1, 2), withIndex = c(1, 1))

library(Spectra)
## import the data and add it to the mse object
spectra(msexp) <- Spectra(fls, backend = MsBackendMzR())

## define the quality metrics to be calculated
metrics <- c("areaUnderTic", "chromatographyDuration", "msSignal10xChange")

## additional parameters passed to the quality metrics functions
## (msLevel is an argument of areaUnderTic and msSignal10xChange,
## relativeTo is an argument of msSignal10xChange) passed to ...
calculateMetricsFromMsExperiment(msexp = msexp, metrics = metrics,
    msLevel = 1, change = "jump", relativeTo = "Q1")

calculateMetricsFromMsExperiment(msexp = msexp, metrics = metrics, 
    msLevel = 1, change = "fall", relativeTo = "previous")

}
\author{
Thomas Naake
}
