##' @title Ai et al (2025) single-cell data
##'
##' @name Ai2025
##'
##' @aliases Ai2025_aCMs_report.tsv Ai2025_iCMs_report.tsv
##'
##' @description
##'
##' Single-cell proteomics captures the Proteome Heterogeneity in Human
##' iPSC-Derived Cardiomyocytes and Adult Cardiomyocytes.
##'
##' Project description (from MassIVE): Human induced pluripotent stem cell
##' (IPSC)-derived cardiomyocytes (iCMs) have become important tools to model
##' cardiovascular diseases and drug toxicology. Despite suggested
##' transcriptomic heterogeneity in both iPSC and iCMs, the cellular proteome
##' heterogeneity is poorly understood. Using cutting-edge single cell
##' proteomics, we quantify the maturation from IPSC to iCMs and observed two
##' distinct populations of iCMs with different metabolism, which recapitulates
##' the single adult cardiomyocyte proteome populations albeit less
##' mature.
##'
##' The two DIA-NN report files are downloaded from the MassIVE dataset
##' MSV000094438 (doi:10.25345/C5T727S7Q) are redistruted here are:
##'
##' - Adult cardiomyocyte (aCMs): 299 cells
##' - iPSC-derived cardiomyocytes (iCMs): 2184 cells
##'
##' Dataset license: CC0 1.0 Universal (CC0 1.0)
##'
##' @references
##'
##' Ai, Lizhuo, Aleksandra Binek, Vladimir Zhemkov, Jae Hyung Cho, Ali Haghani,
##' Simion Kreimer, Edo Israely, et al. 2025. “Single Cell Proteomics Reveals
##' Specific Cellular Subtypes in Cardiomyocytes Derived from Human iPSCs and
##' Adult Hearts.” Mol. Cell. Proteomics, no. 100910 (January):
##' 100910. https://doi.org/10.1016/j.mcpro.2025.100910.
##'
##' @author EuBIC 2025 developper meeting SCP hackathon members
NULL
