% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{ioBenchmark}
\alias{ioBenchmark}
\title{RawFileReader_read_peaks benchmark}
\usage{
ioBenchmark(
  nv = c(1000, 5000, 10000),
  sizev = c(8, 16, 32, 64, 128, 256, 8, 16, 32, 64, 128, 256, 8, 16, 32, 64, 128, 256, 8,
    16, 32, 64, 128, 256, 8, 16, 32, 64, 128, 256, 8, 16, 32, 64, 128, 256),
  rawfile
)
}
\arguments{
\item{nv}{number of spectra to be read.}

\item{sizev}{number of spectra write and parsed in one single junk.}

\item{rawfile}{the Thermo Fisher Scientific raw file.}
}
\value{
\code{data.frame}
}
\description{
derives numbers to evaluate time performance for reading a single spectrum in
dependency from the chunk size (how many spectra are read in one function call)
for reading different numbers of overall spectra.
}
\examples{
eh <- ExperimentHub::ExperimentHub()
EH4547  <- normalizePath(eh[["EH4547"]])
(rawfileEH4547  <- paste0(EH4547 , ".raw"))
if (!file.exists(rawfileEH4547 )){
  file.link(EH4547 , rawfileEH4547)
  }
S <- ioBenchmark(1000, c(128, 256, 128, 256), rawfile=rawfileEH4547)
}
