# Mass Spectrometry Data Backend for Mascot Generic Format (mgf) Files

[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![R-CMD-check-bioc](https://github.com/RforMassSpectrometry/MsBackendMgf/workflows/R-CMD-check-bioc/badge.svg)](https://github.com/RforMassSpectrometry/MsBackendMgf/actions?query=workflow%3AR-CMD-check-bioc)
[![codecov](https://codecov.io/gh/rformassspectrometry/MsBackendMgf/branch/main/graph/badge.svg?token=R1VB6BmWAK)](https://codecov.io/gh/rformassspectrometry/MsBackendMgf)
[![license](https://img.shields.io/badge/license-Artistic--2.0-brightgreen.svg)](https://opensource.org/licenses/Artistic-2.0)
[![years in bioc](http://bioconductor.org/shields/years-in-bioc/MsBackendMgf.svg)](https://bioconductor.org/packages/release/bioc/html/MsBackendMgf.html)
[![Ranking by downloads](http://bioconductor.org/shields/downloads/release/MsBackendMgf.svg)](https://bioconductor.org/packages/stats/bioc/MsBackendMgf/)
[![build release](http://bioconductor.org/shields/build/release/bioc/MsBackendMgf.svg)](https://bioconductor.org/checkResults/release/bioc-LATEST/MsBackendMgf/)
[![build devel](http://bioconductor.org/shields/build/devel/bioc/MsBackendMgf.svg)](https://bioconductor.org/checkResults/devel/bioc-LATEST/MsBackendMgf/)

The `MsBackendMgf` package provides functionality to import and handle
MS/MS spectrum data from Mascot Generic Format
([mgf](http://www.matrixscience.com/help/data_file_help.html)) files.
The package defines the `MsBackendMgf` backend which can be used to
import and use MS2 spectrum data from mgf files with the
[Spectra](https://github.com/rformassspectrometry/Spectra) R package.

For more information see the package
[homepage](https://rformassspectrometry.github.io/MsBackendMgf).


# Installation

The package can be installed with

```r
install.packages("BiocManager")
BiocManager::install("MsBackendMgf")
```


# Contributions

Contributions are highly welcome and should follow the [contribution
guidelines](https://rformassspectrometry.github.io/RforMassSpectrometry/articles/RforMassSpectrometry.html#contributions).
Also, please check the coding style guidelines in the [RforMassSpectrometry
vignette](https://rformassspectrometry.github.io/RforMassSpectrometry/articles/RforMassSpectrometry.html).
