% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment_overall.R
\name{plot_enrichment_overall}
\alias{plot_enrichment_overall}
\title{Plot motif-enrichment for all experiments}
\usage{
plot_enrichment_overall(
  enrichment_df,
  motif_i,
  label_colours,
  reference_label,
  html_tags = TRUE
)
}
\arguments{
\item{enrichment_df}{A data frame containing the motif enrichment results,
produced using \code{\link{get_df_enrichment}}.}

\item{motif_i}{The index of the motif to plot.}

\item{label_colours}{A vector with colours (valid names or hex codes) to use
for "No" and "Yes" bar segments.}

\item{reference_label}{The label of the reference experiment.}

\item{html_tags}{Logical. If TRUE, returns the plot as a \code{tagList}
object.}
}
\value{
A list of \code{plotly} objects with the peak motif enrichment data.
If \code{html_tags} is \code{TRUE}, the function returns a list of
\code{tagList} objects instead. The two plots in the list are named as
follows:
\describe{
 \item{\code{$count_plt}}{y-axis represents the number of peaks.}
 \item{\code{$perc_plt}}{y-axis represents the percentage of peaks.}
}
}
\description{
Visualises the result from \code{\link{get_df_enrichment}} for a single motif
by producing a \code{plotly} bar plot with the motif enrichment comparisons
for all the comparison dataset pair.
}
\seealso{
Other plot functions: 
\code{\link{plot_enrichment_individual}()},
\code{\link{plot_motif_comparison}()}
}
\concept{plot functions}
\keyword{internal}
