% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_df_distances_bootstrapped.R
\name{get_df_distances_bootstrapped}
\alias{get_df_distances_bootstrapped}
\title{Get dataframe with bootstrapped motif-summit distances}
\usage{
get_df_distances_bootstrapped(
  result,
  user_motifs,
  genome_build,
  samples_n = NULL,
  samples_len = NULL,
  out_dir = tempdir(),
  BPPARAM = BiocParallel::bpparam(),
  meme_path = NULL,
  verbose = FALSE
)
}
\arguments{
\item{result}{A \code{list} with the following elements:
\describe{
    \item{peaks}{A \code{list} of peak files generated using
\code{\link{read_peak_file}}.}
    \item{alignments}{A \code{list} of alignment files.}
    \item{exp_type}{A \code{character} vector of experiment types.}
    \item{exp_labels}{A \code{character} vector of experiment labels.}
    \item{read_count}{A \code{numeric} vector of read counts.}
    \item{peak_count}{A \code{numeric} vector of peak counts.}
}}

\item{user_motifs}{A \code{list} with the following elements:
\describe{
    \item{motifs}{A \code{list} of motif files.}
    \item{motif_labels}{A \code{character} vector of motif labels.}
}}

\item{genome_build}{A character string with the abbreviated genome build
name, or a BSGenome object. Check \link{check_genome_build} details for
genome builds which can be imported as abbreviated names.}

\item{samples_n}{An integer specifying the number of bootstrap samples to
generate. If \code{NULL}, it is set to 70\% of the number of peaks.}

\item{samples_len}{An integer specifying the number of peaks to sample in
each bootstrap iteration. If \code{NULL}, it is set to 20% of the number of
peaks.}

\item{out_dir}{A \code{character} vector of output directory.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam-class}} object
enabling parallel execution. (default = SerialParam(), single-CPU run)\cr\cr
Following are two examples of how to set up parallel processing:
\itemize{
  \item \code{BPPARAM = BiocParallel::MulticoreParam(4)}: Uses 4
  CPU cores for parallel processing.
  \item \code{library("BiocParallel")} followed by
  \code{register(MulticoreParam(4))} sets all subsequent BiocParallel
  functions to use 4 CPU cores. \code{Motifpeeker()} must be run
  with \code{BPPARAM = BiocParallel::MulticoreParam()}.
}
\strong{IMPORTANT:} For each worker, please ensure a minimum of 8GB of
memory (RAM) is available as \code{motif_discovery} is
memory-intensive.}

\item{meme_path}{path to \verb{meme/bin/} (optional). Defaut: \code{NULL}, searches
"MEME_PATH" environment variable or "meme_path" option for path to "meme/bin/".}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}
}
\value{
A \code{data.frame} with the following columns:
\describe{
 \item{exp_label}{Experiment labels.}
 \item{exp_type}{Experiment types.}
 \item{motif_indice}{Motif indices.}
 \item{bootstrap_iteration}{Bootstrap iteration number.}
 \item{distance}{Mean of absolute distances between peak summit and motif.}
}
}
\description{
Wrapper for `MotifPeeker::bootstrap_distances` to get bootstrapped
motif-summit distances for given peaks and motifs, generating a
\code{data.frame} suitable for plots.
}
\examples{
if (memes::meme_is_installed()) {
    peak <- system.file("extdata", "CTCF_ChIP_peaks.narrowPeak",
                package = "MotifPeeker") |>
                read_peak_file() |>
                sample(20)
    motif_MA1102.3 <- system.file("extdata", "motif_MA1102.3.jaspar",
                package = "MotifPeeker") |> read_motif_file()
    motif_MA1930.2 <- system.file("extdata", "motif_MA1930.2.jaspar",
                package = "MotifPeeker") |> read_motif_file()

    input <- list(
        peaks = peak,
        exp_type = "ChIP",
        exp_labels = "CTCF",
        read_count = 150,
        peak_count = 100
    )
    motifs <- list(
        motifs = list(motif_MA1930.2, motif_MA1102.3),
        motif_labels = list("MA1930.2", "MA1102.3")
    )
                
    if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38")) {
        genome_build <-
            BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
            
        distances_df_bootstrapped <- get_df_distances_bootstrapped(
            input,
            user_motifs = motifs,
            genome_build = genome_build,
            samples_n = NULL,
            samples_len = NULL,
            verbose = FALSE
        )
        print(distances_df_bootstrapped)
    }
}

}
\seealso{
Other generate data.frames: 
\code{\link{get_df_distances}()},
\code{\link{get_df_enrichment}()}
}
\concept{generate data.frames}
