% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{deriveHeuristicBindingDistribution}
\alias{deriveHeuristicBindingDistribution}
\title{build heurisitc distribution around the binding sites}
\usage{
deriveHeuristicBindingDistribution(
  chipSeq,
  averageBindings,
  windowSize,
  acceptedRegionsOutputFile = "BindingRegions",
  currentDir
)
}
\arguments{
\item{chipSeq}{ChIP-seq aligned 1nt short reads}

\item{averageBindings}{expected short reads number aligned to a random
location of genes of given size}

\item{windowSize}{Window size around binding site. The total region would be
2*windowSize+1}

\item{acceptedRegionsOutputFile}{Accepted binding regions}

\item{currentDir}{Directory for I/O operations}
}
\value{
FRiPs Fraction of Reads in Peaks
}
\description{
This function generates heuristic distribution of short reads
around binding sites which do not need to deconvolve, total numer of short
reads and window size as number of neucleotid around binding sites.

It fits a kernel to the distribution and return the distribution
 as output. The total sum of returned values is equal to one. It plots this
  kernel.

Also it calculates FRiPs (Fraction of Reads in Peaks) for each

  ChIP-seq and returns it. FRiPs and kernel distributions are measures of
   goodness of ChIP-seq experiments and selected motifs.
}
