% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMetExp.R
\name{plotMetExp}
\alias{plotMetExp}
\title{plotMetExp
This function visualizes results of EpiMix.}
\usage{
plotMetExp(
  EpiMix_results,
  probe_name,
  dataMET,
  dataEXP,
  gene_of_interest,
  additionalFilename = ""
)
}
\arguments{
\item{EpiMix_results}{The object, a list, that was returned from
running the EpiMix function and is one of the outputs from the 
GMA function.}

\item{probe_name}{A character string containing the name of the
CpG probe that will be plotted.}

\item{dataMET}{A data matrix containing the methylation data
where the CpG probes are in the rows and samples are in the
columns}

\item{dataEXP}{A data matrix containing the gene expression
data where the genes are in the rows and the samples are in 
the columns}

\item{gene_of_interest}{A character string containing the 
name of the gene that will be plotted.}

\item{additionalFilename}{A character string that can be used
to add a prefix or filepath to the filename of the pdf 
visualizing the heatmap. Default is an empty string.}
}
\value{
No value is returned. Visualizations are saved.
}
\description{
plotMetExp
This function visualizes results of EpiMix.
}
\examples{
data("EpiMix_Results_Regular")
data("dataMethyl")
data("dataFilt")
pattern <- "^(.{4}-.{2}-.{4}-.{2}).*"
colnames(dataFilt) <- sub(pattern, "\\\\1", colnames(dataFilt))
plotMetExp(EpiMix_results = EpiMix_Results_Regular,
           probe_name = "cg03035704",
           dataMET = dataMethyl,
           dataEXP = dataFilt,
           gene_of_interest = "ACVRL1",
           additionalFilename = "./GMAresults/")
}
