% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-ModString.R
\name{ModRNAString}
\alias{ModRNAString}
\title{ModDNAString class}
\usage{
ModRNAString(x = "", start = 1, nchar = NA)
}
\arguments{
\item{x}{the input as a \code{character}.}

\item{start}{the postion in the character vector to use as start position in
the \code{ModRNAString} object (default \code{start = 1}).}

\item{nchar}{the width of the character vector to use in the 
\code{ModRNAString} object (default \code{nchar = NA}). The end position is
calculated as \code{start + nchar - 1}.}
}
\value{
a \code{ModRNAString} object
}
\description{
A \code{ModRNAString} object allows RNA sequences with modified nucleotides
to be stored and manipulated.
}
\details{
The ModRNAString class contains the virtual \code{\link{ModString}} class,
which is itself based on the \code{\link[Biostrings:XString-class]{XString}}
class. Therefore, functions for working with \code{XString} classes are 
inherited.

The alphabet of the ModRNAString class consist of the non-extended IUPAC 
codes "A,G,C,U", the gap letter "-", the hard masking letter "+", the not 
available letter "." and letters for individual modifications: 
\code{alphabet(ModRNAString())}.

Since the special characters are encoded differently depending on the OS and
encoding settings of the R session, it is not always possible to enter a RNA
sequence containing modified nucleotides via the R console. The most 
convinient solution for this problem is to use the function 
\code{\link{modifyNucleotides}} and modify and existing RNAString or
ModRNAString object.

A \code{ModRNAString} object can be converted into a \code{RNAString} object
using the \code{RNAstring()} constructor. Modified nucleotides are 
automaitcally converted intro their base nucleotides.

If a modified RNA nucleotide you want to work with is not part of the
alphabet, please let us know.
}
\examples{
# Constructing ModDNAString containing an m6A and a dihydrouridine
mr1 <- ModRNAString("AGCU`D")
mr1

# the alphabet of the ModRNAString class
alphabet(mr1)
# due to encoding issues the shortNames can also be used
shortName(mr1)
# due to encoding issues the nomenclature can also be used
nomenclature(mr1)

# convert to RNAString
r1 <- RNAString(mr1)
r1
}
