% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_clust.R
\name{mp_cal_clust}
\alias{mp_cal_clust}
\alias{mp_cal_clust,MPSE-method}
\alias{mp_cal_clust,MPSE}
\alias{mp_cal_clust,tbl_mpse-method}
\alias{mp_cal_clust,tbl_mpse}
\alias{mp_cal_clust,grouped_df_mpse-method}
\alias{mp_cal_clust,grouped_df_mpse}
\title{Hierarchical cluster analysis for the samples with MPSE or tbl_mpse object}
\usage{
mp_cal_clust(
  .data,
  .abundance,
  distmethod = "bray",
  hclustmethod = "average",
  action = "get",
  ...
)

\S4method{mp_cal_clust}{MPSE}(
  .data,
  .abundance,
  distmethod = "bray",
  hclustmethod = "average",
  action = "get",
  ...
)

\S4method{mp_cal_clust}{tbl_mpse}(
  .data,
  .abundance,
  distmethod = "bray",
  hclustmethod = "average",
  action = "get",
  ...
)

\S4method{mp_cal_clust}{grouped_df_mpse}(
  .data,
  .abundance,
  distmethod = "bray",
  hclustmethod = "average",
  action = "get",
  ...
)
}
\arguments{
\item{.data}{the MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{distmethod}{the method of distance.}

\item{hclustmethod}{the method of hierarchical cluster}

\item{action}{a character "add" will return a MPSE object with the cluster 
result as a attributes, and it can be extracted with 'object %>% mp_extract_cluster()', 
"only" or "get" will return 'treedata' object, default is 'get'.}

\item{...}{additional parameters}
}
\value{
update object with the action argument, the treedata object 
contained hierarchical cluster analysis of sample, it can be visualized 
with 'ggtree' directly.
}
\description{
Hierarchical cluster analysis for the samples with MPSE or tbl_mpse object
}
\examples{
library(ggtree)
library(ggplot2)
data(mouse.time.mpse)
res <- mouse.time.mpse \%>\%
 mp_decostand(.abundance=Abundance) \%>\% 
 mp_cal_clust(.abundance=hellinger, distmethod="bray")
res
res \%>\%
 ggtree() + 
 geom_tippoint(aes(color=time))
}
\author{
Shuangbin Xu
}
