% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethPed_dataset.R
\docType{data}
\name{MethPed_900probes}
\alias{MethPed_900probes}
\title{List of 900 probes in the predictor data}
\format{Data frame of 900 probes.}
\usage{
data(MethPed_900probes)
}
\value{
450k methylation array probe name
}
\description{
List of 900 probes in the predictor (Training data for Random Forest model)
}
\details{
For the construction of the training probe pool (predictors), methylation data generated by
the Illumina Infinium HumanMethylation 450 BeadChip arrays were downloaded from the Gene Expression
Omnibus (GEO). Four hundred seventy-two cases were available, representing several brain tumor diagnoses
(DIPG, glioblastoma, ETMR, medulloblastoma, ependymoma, pilocytic astrocytoma) and their further subgroups.

The data sets were merged and probes that did not appear in all data sets were filtered away. In addition,
about 190,000 CpGs were removed due to SNPs, repeats and multiple mapping sites. The final data set contained
206,823 unique probes and nine tumor classes including the medulloblastoma subgroups. K–neighbor imputation
was used for missing probe data.

After that, a large number of regression analyses were performed to select the 100 probes per tumor class that
had the highest predictive power (AUC values). Based on the identified 900 methylation sites, the nine pediatric
brain tumor types could be accurately classified using the multiclass classification algorithm MethPed.
}
\examples{
#################### Loading and view sample data
data(MethPed_900probes)
head(MethPed_900probes)

}
\references{
[1] Anna Danielsson, Szilárd Nemes, Magnus Tisell, Birgitta Lannering, Claes Nordborg, Magnus Sabel, and Helena Carén. "MethPed: A DNA Methylation Classifier Tool for the Identification of Pediatric Brain Tumor Subtypes". Clinical Epigenetics 2015, 7:62, 2015
}
\seealso{
See \url{http://www.clinicalepigeneticsjournal.com/content/7/1/62} for more details.
}
\keyword{data}

