% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_dynamics.R
\name{compare_dynamics}
\alias{compare_dynamics}
\title{Comparison of metabolite dynamics clusters under different experimental conditions}
\usage{
compare_dynamics(data, cores = 4)
}
\arguments{
\item{data}{result of \code{\link[=cluster_dynamics]{cluster_dynamics()}} function: either a list of data frames or a SummarizedExperiment object}

\item{cores}{how many cores should be used for model fitting; this
parallelizes the model fitting and therefore speeds it up; default=4}
}
\value{
a list holding a 1) the model fit
2) dataframe of estimates of the mean distance
between #' clusters of different experimental conditions ("mean") and the
standard deviation ("sigma"). If data input
was a SummarizedExperiment results are stored in metadata(data) under
"comparison_dynamics"
}
\description{
Employs a Bayesian model that assumes a normal distribution of Euclidean
distances between dynamics vectors (metabolite abundances at different
time points) of two clusters that come from different
experimental conditions to estimate the mean distance between clusters.
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition \%in\% c("A", "B") &
  longitudinalMetabolomics$metabolite \%in\% c("ATP", "L-Alanine", "GDP")]
data <- fit_dynamics_model(
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- estimates_dynamics(
  data = data
)
data <- cluster_dynamics(data, B = 1)
data <- compare_dynamics(
  data = data,
  cores = 1
)
S4Vectors::metadata(data)[["comparison_dynamics"]]
}
\seealso{
Visualization of estimates \code{\link[=heatmap_dynamics]{heatmap_dynamics()}}/
compare metabolite composition of clusters \code{\link[=compare_metabolites]{compare_metabolites()}}
}
