% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-isotope.R
\name{isotopicSubstitutionMatrix}
\alias{isotopicSubstitutionMatrix}
\title{Definitions of isotopic substitutions}
\usage{
isotopicSubstitutionMatrix(source = c("HMDB_NEUTRAL"))
}
\arguments{
\item{source}{\code{character(1)} defining the set of predefined parameters and
isotopologue definitions to return.}
}
\value{
\code{data.frame} with parameters to detect the defined isotopic
substitutions
}
\description{
In order to identify potential isotopologues based on only m/z and intensity
values with the \code{\link[=isotopologues]{isotopologues()}} function, sets of pre-calculated parameters
are required. This function returns such parameter sets estimated on
different sources/databases. The nomenclature used to describe isotopes
follows the following convention: the number of neutrons is provided in \code{[}
as a prefix to the element and the number of atoms of the element as suffix.
\verb{[13]C2[37]Cl3} describes thus an isotopic substitution containing 2 \verb{[13]C}
isotopes and 3 \verb{[37]Cl} isotopes.

Each row in the returned \code{data.frame} is associated with an isotopic
substitution (which can involve isotopes of several elements or different
isotopes of the same element). In general for each isotopic substitution
multiple rows are present in the \code{data.frame}. Each row provides parameters
to compute bounds (for the ratio between the isotopologue peak and the
monoisotopic one) on a certain mass range. The provided isotopic
substitutions are in general the most frequently observed substitutions in
the database (e.g. HMDB) on which they were defined. Parameters (columns)
defined for each isotopic substitution are:
\itemize{
\item \code{"minmass"}: the minimal mass of a compound for which the isotopic
substitution was found. Peaks with a mass lower than this will most likely
not have the respective isotopic substitution.
\item \code{"maxmass"}: the maximal mass of a compound for which the isotopic
substitution was found. Peaks with a mass higher than this will most likely
not have the respective isotopic substitution.
\item \code{"md"}: the mass difference between the monoisotopic peak and a peak of an
isotopologue characterized by the respective isotopic substitution.
\item \code{"leftend"}: left endpoint of the mass interval.
\item \code{"rightend"}: right endpoint of the mass interval.
\item \code{"LBint"}: intercept of the lower bound line on the mass interval whose
endpoints are \code{"leftend"} and \code{"rightend"}.
\item \code{"LBslope"}: slope of the lower bound line on the mass interval.
\item \code{"UBint"}: intercept of the upper bound line on the mass interval.
\item \code{"UBslope"}: slope of the upper bound line on the mass interval.
}
}
\section{Available pre-calculated substitution matrices}{

\itemize{
\item \code{source = "HMDB"}: most common isotopic substitutions and parameters for
these have been calculated for all compounds from the
\href{https://hmdb.ca}{Human Metabolome Database} (HMDB, July 2021). Note that
the substitutions were calculated on the \strong{neutral masses} (i.e. the
chemical formulas of the compounds, not considering any adducts).
}
}

\examples{

## Get the substitution matrix calculated on HMDB
isotopicSubstitutionMatrix("HMDB_NEUTRAL")
}
\author{
Andrea Vicini
}
