% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adducts.R
\name{adductFormula}
\alias{adductFormula}
\title{Calculate a table of adduct (ionic) formulas}
\usage{
adductFormula(formulas, adduct = "[M+H]+", standardize = TRUE)
}
\arguments{
\item{formulas}{\code{character} with molecular formulas for which adduct
formulas should be calculated.}

\item{adduct}{\code{character} or \code{data.frame} of valid adduct. to be used.
Custom adduct definitions can be provided via a \code{data.frame} but its format
must follow \code{\link[=adducts]{adducts()}}}

\item{standardize}{\code{logical(1)} whether to standardize the molecular formulas
to the Hill notation system before calculating their mass.}
}
\value{
\code{character} matrix with \emph{formula} rows and \emph{adducts} columns
containing all ion formulas. In case an ion can't be generated (eg.
[M-NH3+H]+ in a molecule that doesn't have nitrogen), a NA is returned
instead.
}
\description{
\code{adductFormula} calculates the chemical formulas for the specified adducts
of provided chemical formulas.
}
\examples{

# Calculate the ion formulas of glucose with adducts [M+H]+, [M+Na]+ and [M+K]+
adductFormula("C6H12O6", c("[M+H]+", "[M+Na]+", "[M+K]+"))

# > "[C6H13O6]+" "[C6H12O6Na]+" "[C6H12O6K]+"

# Use a custom set of adduct definitions (For instance, a iron (Fe2+) adduct)
custom_ads <- data.frame(name = "[M+Fe]2+", mass_multi = 0.5, charge = 2,
                         formula_add = "Fe", formula_sub = "C0",
                         positive = "TRUE")
adductFormula("C6H12O6", custom_ads)

}
\seealso{
\code{\link[=adductNames]{adductNames()}} for a list of all available predefined adducts and
\code{\link[=adducts]{adducts()}} for the adduct \code{data.frame} definition style.
}
\author{
Roger Gine
}
