% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubblePlot.R
\name{bubblePlot}
\alias{bubblePlot}
\title{Create a Bubble Plot for Individual Samples}
\usage{
bubblePlot(scorelist, labeltext, labelsize = 0.25)
}
\arguments{
\item{scorelist}{dataframe(1) the output of Pathway Analysis fun}

\item{labeltext}{character(1) what to label points by: LogFC or Pval}

\item{labelsize}{numeric(1) size of text labels for points}
}
\value{
bubblePlot() returns a bubble plot using pathway scores, pval, logfc
}
\description{
Create a Bubble Plot for Individual Samples
}
\examples{
brca <- read.csv(system.file("extdata/BRCA_Scores.csv",
                    package = "MetaPhOR"),
                    header = TRUE,
                    row.names = 1)

#Bubble Plot Labeled By P Value
bubblePlot(scorelist = brca,
            labeltext = "Pval",
            labelsize = .85)

#Bubble Plot Labeled by LogFC
bubblePlot(scorelist = brca,
            labeltext = "LogFC",
            labelsize = .85)
}
