% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchCluster.R
\name{searchCluster}
\alias{searchCluster}
\title{Search for clusters using pre-defined labels}
\usage{
searchCluster(fcsFrame, clusterLabel, cutoff = NULL, rmNull = TRUE,
  preGate = NULL)
}
\arguments{
\item{fcsFrame}{A flowFrame object.}

\item{clusterLabel}{A vector of labels, such as "CD3+|CD4+|CD8-". Each marker
is followed by "+" or "-" and are separated by "|".}

\item{cutoff}{A vector of cutoff values to bisect the distribution of each
marker. The names of the vector should be the same as the marker names. If
NULL, the cutoff value will be determined automatically.}

\item{rmNull}{True or False. Used to specify if a cluster with 0 cells should
be returned or not.}

\item{preGate}{A character string specifying the gated used to clean up the
data. For example, use "PI-" to only analyze live cell. Or use
"Cell_Length+" to only analyze non-debris.}
}
\value{
Returns a list with two components: 1) clusterList is a list in which
  each element of the list is a vector containing the ID of all cells in a
  cluster. The names correspond to the labels specified in clusterLabel. 2)
  cutoff, contains a vector of cutoff values used to bisect each marker.
}
\description{
A function that searches for clusters using pre-defined labels (cell
definitions).
}
\examples{
# Find fcs files
files=system.file("extdata","SDY420/ResultFiles/CyTOF_result",
                  package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
# Preprocess
fcs = preprocessing(fcsFiles=files,assay ="CyTOF",b=1/8)
# Search clusters
cluster_list=searchCluster(fcsFrame=fcs,
                           clusterLabel=c("CD3+|CD8+","CD3-|CD19+"))
}
