% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleInfoParser.R
\name{sampleInfoParser}
\alias{sampleInfoParser}
\title{Collect sample information for fcs files in a study from ImmPort.}
\usage{
sampleInfoParser(metaData, studyFolder, fcsCol = "ZBXFN", assay = "FCM",
  attrCol)
}
\arguments{
\item{metaData}{A data frame. Must contain a column listing the names of fcs
files included in the study.}

\item{studyFolder}{Path of the directory containing all the files of a study
from ImmPort.}

\item{fcsCol}{A string specifying the name of the column in metaData that
lists fcs files included in the study.}

\item{assay}{Either "FCM" or "CyTOF" to indicate the type of cytometry data.}

\item{attrCol}{A vector of column names. Used to specify the information
about each cytometry the user wish to include in the analysis.}
}
\value{
A dataframe containing sample information.
}
\description{
A function that collects sample information for fcs files in a study from
ImmPort.
}
\examples{
fn=system.file("extdata",
               "SDY736/SDY736-DR19_Subject_2_Flow_cytometry_result.txt",
               package="MetaCyto")
meta_data=read.table(fn,sep='\\t',header=TRUE,check.names=FALSE)
# Find the AGE, GENDER info from selected_data
fn=system.file("extdata","SDY736",package="MetaCyto")
sample_info_SDY736=sampleInfoParser(metaData=meta_data,
                                    studyFolder=fn,
                                    assay="FCM",
                                    fcsCol="File Name",
                                    attrCol=c("Subject Age","Gender"))
}
