% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.batch.R
\name{preprocessing.batch}
\alias{preprocessing.batch}
\title{Preprocessing fcs files from different studies in batch.}
\usage{
preprocessing.batch(inputMeta, assay = c("FCM", "CyTOF"), outpath,
  b = 1/150, fileSampleSize = 5000,
  excludeTransformParameters = c("FSC-A", "FSC-W", "FSC-H", "Time",
  "Cell_length"))
}
\arguments{
\item{inputMeta}{A data frame containing 2 columns: a column called
"fcs_files" that contains the location (relative to the working directory)
of each fcs file on the hard drive and a column called "study_id" that
specify what study each fcs file belongs to.}

\item{assay}{A vector, each element is either "FCM" or "CyTOF" to indicate
the type of cytometry data.}

\item{outpath}{A string indicating the directory the pre-processed fcs files
will be written to.}

\item{b}{A positive number used to specify the arcsinh transformation. f(x) =
asinh (b*x) where x is the original value and f(x) is the value after
transformation. The suggested value is 1/150 for flow cytometry (FCM) data
and 1/8 for CyTOF data. If b = 0, the transformation is skipped.}

\item{fileSampleSize}{An integer specifying the number of events sampled from
each fcs file. If NULL, all the events will be pre-processed and wrote out
to the new fcs files.}

\item{excludeTransformParameters}{A vector specifying the name of parameters
not to be transformed (left at linear scale).}
}
\value{
Does not return anything. The output is written to the directory
  specified by the "outpath".
}
\description{
It transform and compensate for the raw fcs files and write out the processed
data to a new set of fcs files.
}
\details{
The function takes a data frame which specifies the location of the
  fcs files and the panels the fcs files belong to. It transform the
  cytometry data using the arcsinh transformation. For flow cytometry data,
  it compensate the data using the compensation matrix supplied in the fcs
  file. the preprocessed fcs files and a table called
  "processed_sample_summary.csv" will be wrote out to outpath as well.
}
\examples{
#get meta-data
fn=system.file("extdata","fcs_info.csv",package="MetaCyto")
fcs_info=read.csv(fn,stringsAsFactors=FALSE,check.names=FALSE)
fcs_info$fcs_files=system.file("extdata",fcs_info$fcs_files,package="MetaCyto")
# make sure the transformation parameter "b" and the "assay" argument are
# correct for FCM and CyTOF files
b=assay=rep(NA,nrow(fcs_info))
b[grepl("CyTOF",fcs_info$study_id)]=1/8
b[grepl("FCM",fcs_info$study_id)]=1/150
assay[grepl("CyTOF",fcs_info$study_id)]="CyTOF"
assay[grepl("FCM",fcs_info$study_id)]="FCM"
# preprocessing
preprocessing.batch(inputMeta=fcs_info,
                    assay=assay,
                    b=b,
                    outpath="Example_Result/preprocess_output",
                    excludeTransformParameters=c("FSC-A","FSC-W","FSC-H",
                    "Time","Cell_length"))
}
