% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelCluster.R
\name{labelCluster}
\alias{labelCluster}
\title{Label each cluster as "+" or "-" or neutral for each marker}
\usage{
labelCluster(fcsFrame, clusterList, excludeClusterParameters = c("TIME"),
  minPercent = 0.05, labelQuantile = 0.95, cutoff = NULL)
}
\arguments{
\item{fcsFrame}{A flowFrame object.}

\item{clusterList}{A list, each element should be a vector containing the IDs
of all cells that belongs to a cluster}

\item{excludeClusterParameters}{A vector specifying the name of markers not
to be used for labeling.}

\item{minPercent}{A number between 0 and 0.5. Used to specify the minimum
percent of cells in the positive and negative region after bisection. Keep it
small to avoid bisecting uni-mode distributions.}

\item{labelQuantile}{A number between 0.5 and 1. Used to specify the minimum
percent of a cluster required to be larger or smaller than the cutoff value
for labeling.}

\item{cutoff}{A vector of cutoff values to bisect the distribution of each
marker. The names of the vector should be the same as the marker names. If
NULL, the cutoff value will be determined automatically.}
}
\value{
Returns a list with two components: 1) clusterLabel, contains a
  vector of labels, each corresponds to a cluster in clusterList. 2) cutoff,
  contains a vector of cutoff values used to bisect each marker.
}
\description{
A function that labels each cluster as "+" or "-" or neutral for each marker
}
\examples{
# Find fcs files
files=system.file("extdata","SDY420/ResultFiles/CyTOF_result",
                  package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
# Preprocess
fcs = preprocessing(fcsFiles=files,assay ="CyTOF",b=1/8)
# cluster using flowSOM.MC
cluster_list=flowSOM.MC(fcsFrame=fcs,
                        excludeClusterParameters=c("Time","Cell_length"))
# label each clusters
cluster_label=labelCluster(fcsFrame=fcs,clusterList=cluster_list,
                           excludeClusterParameters=c("Time","Cell_length"))
}
