% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcsInfoParser.R
\name{fcsInfoParser}
\alias{fcsInfoParser}
\title{Organize fcs files in a study from ImmPort into panels}
\usage{
fcsInfoParser(metaData, studyFolder, fcsCol = "ZBXFN", assay = c("FCM",
  "CyTOF"))
}
\arguments{
\item{metaData}{A data frame. Must contain a column listing the names of fcs
files included in the study.}

\item{studyFolder}{Path of the directory containing all the files of a study
from ImmPort.}

\item{fcsCol}{A string specifying the name of the column in metaData that
lists fcs files included in the study.}

\item{assay}{Either "FCM" or "CyTOF" to indicate the type of cytometry data.}
}
\value{
A dataframe containing 2 columns: a column called "fcs_files" that
  contains the location (relative to the working directory) of each fcs file
  on the hard drive and a column called "study_id" that specify what study
  each fcs file belongs to.
}
\description{
A function that organizes fcs files in a study from ImmPort into panels.
}
\examples{
fn=system.file("extdata",
              "SDY736/SDY736-DR19_Subject_2_Flow_cytometry_result.txt",
              package="MetaCyto")
meta_data=read.table(fn,sep='\\t',header=TRUE, check.names= FALSE)
# Organize fcs file into panels
fn=system.file("extdata","SDY736",package="MetaCyto")
fcs_info_SDY736=fcsInfoParser(metaData=meta_data,
                              studyFolder=fn,
                              fcsCol="File Name",
                              assay="FCM")
}
