% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityPlot.R
\name{densityPlot}
\alias{densityPlot}
\title{Draw density plot for each cell cluster.}
\usage{
densityPlot(fcsFrame, clusterList, cutoff, markerToPlot = NULL)
}
\arguments{
\item{fcsFrame}{A flow Frame object returned from preprocessing function.}

\item{clusterList}{A list, each element should be a vector containing the IDs
of all cells that belong to a cluster}

\item{cutoff}{A vector of cutoff values to bisect the distribution of each
marker. The names of the vector should be the same as the marker names.}

\item{markerToPlot}{A vector specifying markers included in the plot. If
NULL, all markers will be plotted.}
}
\value{
NULL. The plot will show up automatically.
}
\description{
A function that draws density plot for each cell cluster.
}
\details{
The plot can be very large, we suggest plotting it into a pdf jpeg
  file directly.
}
\examples{
# Find fcs files
files=system.file("extdata","SDY420/ResultFiles/CyTOF_result",
                  package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
# Preprocess
fcs = preprocessing(fcsFiles=files,assay ="CyTOF",b=1/8)
# Search clusters
cluster_list=searchCluster(fcsFrame=fcs,
                           clusterLabel=c("CD3+|CD8+","CD3-|CD19+"))
# plot density plot for clusters
densityPlot(fcs,
            clusterList=cluster_list$clusterList,
            cutoff=cluster_list$cutoff,
            markerToPlot=c("CD3","CD8","CD19"))
}
