% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectData.R
\name{collectData}
\alias{collectData}
\title{Collect and combine data from multiple csv files of the same format}
\usage{
collectData(files, longform = TRUE)
}
\arguments{
\item{files}{A vector containing the paths of csv files to be combined.}

\item{longform}{True or False. Used to specify if the table in each csv file
should be converted into long form before combining.}
}
\value{
A dataframe containing combined information from multiple csv files.
}
\description{
A function that collect and combine data from multiple csv files of the same
format.
}
\examples{
# find all the files we want to combine
fn=system.file("extdata","",package="MetaCyto")
fn=list.files(fn,pattern="cluster_stats_in_each_sample",full.names=TRUE)
# Comine the data
all_data = collectData(fn,longform=TRUE)
}
