% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_test-data.R
\docType{data}
\name{mat_test_z}
\alias{mat_test_z}
\title{Example data for \code{MetNet}: unit tests}
\format{
\code{matrix}
}
\source{
set.seed(1)
random_numbers <- rnorm(140, mean = 10, sd = 2)
mat_test <- matrix(random_numbers, nrow = 7)
mat_test[1:3, ] <- t(apply(mat_test[1:3, ], 1, sort))
mat_test[5:7, ] <- t(apply(mat_test[5:7, ], 1, sort, decreasing = TRUE))
rownames(mat_test) <- paste("x", 1:7, sep = "")
mat_test_z <- apply(mat_test, 1, function(x)
                    (x - mean(x, na.rm = TRUE))/sd(x, na.rm = TRUE))
}
\value{
\code{matrix}
}
\description{
\code{mat_test_z} contains 7 toy features that were derived
from \code{rnorm}. It will be used as an example data set in unit tests.
}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
