% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_match_class.R
\name{rt_match}
\alias{rt_match}
\title{rt matching}
\usage{
rt_match(variable_meta, rt_column, rt_window, id_column, ...)
}
\arguments{
\item{variable_meta}{(data.frame) A data.frame of variable IDs and
their corresponding rt values.}

\item{rt_column}{(character) Column name of the rt values in
variable_meta.}

\item{rt_window}{(numeric, integer) Rt window to use for matching. If
a single value is provided then the same rt is used for both variable
meta and the annotations. A named vector can also be provided e.g.
c("variable_meta"=5,"annotations"=2) to use different ", "windows for
each data table.}

\item{id_column}{(character) Column name of the variable ids in
variable_meta. ", "id_column="rownames" will use the rownames as ids.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{rt_match} object with the following \code{output}
slots:
\tabular{ll}{
\code{updated} \tab (annotation_table) The input annotation source
with the newly generated column. \cr
}
}
\description{
Annotations will be matched to the measured variable
meta data.frame by determining which annotations rt window overlaps
with the rt window from the measured rt.
}
\section{Inheritance}{

A \code{rt_match} object inherits the following \code{struct} classes: \cr\cr
\verb{[rt_match]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- rt_match(
        variable_meta = data.frame(),
        rt_column = character(0),
        rt_window = 20,
        id_column = character(0))

}
