% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_range_class.R
\name{filter_range}
\alias{filter_range}
\title{Filter by range}
\usage{
filter_range(
  column_name,
  upper_limit = Inf,
  lower_limit = -Inf,
  equal_to = TRUE,
  ...
)
}
\arguments{
\item{column_name}{(character) The column name to filter.}

\item{upper_limit}{(numeric, integer, function) The upper limit used
for filtering. Can be a value, or a function that computes a value
(e.g. mean). The default is \code{Inf}.\cr}

\item{lower_limit}{(numeric, integer, function) The lower limit used
for filtering. Can be a value, or a function that computes a value
(e.g. mean). The default is \code{-Inf}.}

\item{equal_to}{(logical) Equal to limits. Allowed values are limited
to the following: \itemize{ \item{\code{"TRUE"}: Greater/less than or
equal to the limits are excluded.}\item{\code{"FALSE"}: Greater/less
than the limits are excluded.}} The default is \code{TRUE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{filter_range} object with the following \code{output}
slots:
\tabular{ll}{
\code{filtered} \tab (annotation_source) Annotation_source after
filtering. \cr
\code{flags} \tab (data.frame) A list of flags indicating which
annotations were removed. \cr
}
}
\description{
Removes annotations where the names column is greater
than an upper limit or less than a lower limit.
}
\section{Inheritance}{

A \code{filter_range} object inherits the following \code{struct} classes:
\cr\cr
\verb{[filter_range]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- filter_range(
        column_name = "V1",
        upper_limit = Inf,
        lower_limit = -Inf,
        equal_to = FALSE)

}
