% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testNeutral.R
\name{testNeutral}
\alias{testNeutral}
\title{testNeutral}
\usage{
testNeutral(
  maf,
  patient.id = NULL,
  withinTumor = FALSE,
  min.total.depth = 2,
  min.vaf = 0.1,
  max.vaf = 0.3,
  R2.threshold = 0.98,
  min.mut.count = 20,
  plot = TRUE,
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{withinTumor}{Test neutral within tumros in each patients. Default FALSE.}

\item{min.total.depth}{The minimun total depth of coverage. Defalut 2}

\item{min.vaf}{The minimum value of adjusted VAF value. Default 0.1}

\item{max.vaf}{The maximum value of adjusted VAF value. Default 0.3}

\item{R2.threshold}{The threshod of R2 to decide whether a tumor follows neutral evolution. Default 0.98}

\item{min.mut.count}{The minimun number of subclonal mutations used to fit model. Default 20}

\item{plot}{Logical, whether to print model fitting plot of each sample. Default TRUE.}

\item{use.tumorSampleLabel}{Let Tumor_Sample_Barcode replace Tumor_Sample_Label if Tumor Label is provided in clinical data. Default FALSE.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
the neutrality metrics and model fitting plots
}
\description{
Evaluate whether a tumor follows neutral evolution or under strong selection during the growth based on variant frequency distribution (VAF) of subclonal mutations.
The subclonal mutant allele frequencies of a follow a simple power-law distribution predicted by neutral growth.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
testNeutral(maf)
}
\references{
Williams, M., Werner, B. et al. Identification of neutral tumor evolution across cancer types. Nat Genet 48, 238-244 (2016)
}
