% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calNeiDist.R
\name{calNeiDist}
\alias{calNeiDist}
\title{calNeiDist}
\usage{
calNeiDist(
  maf,
  patient.id = NULL,
  withinTumor = FALSE,
  min.ccf = 0,
  plot = TRUE,
  use.circle = TRUE,
  title = NULL,
  number.cex = 8,
  number.col = "#C77960",
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{A Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{withinTumor}{Calculate between-region heterogeneity within tumor. 
(Default: FALSE).}

\item{min.ccf}{Specify the minimum CCF. Default 0.}

\item{plot}{Logical (Default: TRUE).}

\item{use.circle}{Logical (Default: TRUE). Whether to use "circle" as visualization method of correlation matrix.}

\item{title}{The title of the plot. Default "Nei's distance"}

\item{number.cex}{The size of text shown in correlation plot. Default 8.}

\item{number.col}{The color of text shown in correlation plot. Default "#C77960".}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
Nei's genetic distance matrix and heatmap of sample-pairs from the same patient
}
\description{
Nei's distance of CCF for sample/tumor pair.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
calNeiDist(maf)
}
\references{
Lee JK, Wang J, Sa JK, et al. Spatiotemporal genomic architecture informs precision oncology in glioblastoma. Nat Genet. 2017;49(4):594-599.
}
