\name{PermutatonTest}

\alias{PermutationTest}

\title{ Permutation Test for Dissimilarity Matrices }

\description{
  'PermutationTest' computes and returns an empirical p-value from a 
  null distribution generated by permuting 'Dfull' a total of 'num.per' times.
}


\usage{
PermutationTest(Dfull, Dsubsets, num.per, num.chips, alpha)
}


\arguments{
  \item{     Dfull}{dissimilarity matrix from the original (p x n) microarray expression data}
  \item{     Dsubsets}{dissimilarity matrices from each k disjoint clusters returned by 'GetClusters'}
  \item{     num.per   }{number of permutations }
  \item{     num.chips}{number of samples, 'n' from the original (p x n) data matrix }
  \item{     alpha     }{desired level of significance}
}


\details{
  For each permutation, k Mantel correlations are computed by correlating the permuted 'Dfull' with each dissimilarity
  matrix 'Dsubsets' from the 'k' clusters returned by 'GetClusters'.  The absolute value
  of the maximum Mantel cluster correlation is retained at each permutation.  These
  'num.per' maximum correlations are then used to generate a null distribution for
  distance metric independence, with the p-value taken from the (1 - 'alpha') percentile
  of this permutation distribution.
}

\value{
  returns the permuted p-value for the 'alpha' selected level of significance
}

\note{ The function is meant to be executed AFTER 'GetClustes', 'DistMatrices' and 'MantelCorr' (see example) }

\author{ Brian Steinmeyer }

\section{Warning}{ (p x n) data matrix should be numeric (e.g. gene-expression levels) }

\seealso{ 'GetClusters' 'DistMatrices' 'MantelCorrs' }

\examples{
%\dontrun{
# simulate a p x n microarray expression dataset, where p = genes and n = samples
data.sep <- rbind(matrix(rnorm(1000), ncol=50), matrix(rnorm(1000, mean=5), ncol=50))
noise <- matrix(runif(40000), ncol=1000)
data <- t(cbind(data.sep, noise))
data <- data[1:200, ]
# data has p = 1,050 genes and n = 40 samples

clusters.result <- GetClusters(data, 100, 100)
dist.matrices <- DistMatrices(data, clusters.result$clusters)
mantel.corrs <- MantelCorrs(dist.matrices$Dfull, dist.matrices$Dsubsets)
permutation.result <- PermutationTest(dist.matrices$Dfull, dist.matrices$Dsubsets, 100, 40, 0.05)

}
%}

\keyword{ cluster }% at least one, from doc/KEYWORDS

