% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonPlots.R
\name{.plotComparison}
\alias{.plotComparison}
\title{Preprocess data for comparison plots and create them}
\usage{
.plotComparison(
  input,
  proteins,
  address,
  width,
  height,
  sig,
  ylimUp,
  ylimDown,
  text.angle,
  dot.size,
  x.axis.size,
  y.axis.size,
  log_base_FC,
  isPlotly
)
}
\arguments{
\item{input}{data.table}

\item{address}{the name of folder that will store the results. Default folder is the current working directory. The other assigned folder has to be existed under the current working directory. An output pdf file is automatically created with the default name of "VolcanoPlot.pdf" or "Heatmap.pdf" or "ComparisonPlot.pdf". The command address can help to specify where to store the file as well as how to modify the beginning of the file name. If address=FALSE, plot will be not saved as pdf file but showed in window.}

\item{width}{width of the saved file in pixels. Default is 800.}

\item{height}{height of the saved file in pixels. Default is 600.}

\item{sig}{FDR cutoff for the adjusted p-values in heatmap and volcano plot. level of significance for comparison plot. 100(1-sig)\% confidence interval will be drawn.  sig=0.05 is default.}

\item{ylimUp}{for all three plots, upper limit for y-axis. FALSE (default) for volcano plot/heatmap use maximum of -log2 (adjusted p-value) or -log10 (adjusted p-value). FALSE (default) for comparison plot uses maximum of log-fold change + CI.}

\item{ylimDown}{for all three plots, lower limit for y-axis. FALSE (default) for volcano plot/heatmap use minimum of -log2 (adjusted p-value) or -log10 (adjusted p-value). FALSE (default) for comparison plot uses minimum of log-fold change - CI.}

\item{text.angle}{angle of x-axis labels represented each comparison at the bottom of graph in comparison plot. Default is 0.}

\item{dot.size}{size of dots in volcano plot and comparison plot. Default is 3.}

\item{x.axis.size}{size of axes labels, e.g. name of the comparisons in heatmap, and in comparison plot. Default is 10.}

\item{y.axis.size}{size of axes labels, e.g. name of targeted proteins in heatmap. Default is 10.}

\item{log_base_FC}{log base for log-fold changes - 2 or 10}

\item{isPlotly}{This parameter is for MSstatsShiny application for plotly 
render, this cannot be used for saving PDF files as plotly do not have 
suppprt for PDFs currently. address and isPlotly cannot be set as TRUE at the
same time.}
}
\description{
Preprocess data for comparison plots and create them
}
\keyword{internal}
