% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonTMT.R
\name{groupComparisonTMT}
\alias{groupComparisonTMT}
\title{Finding differentially abundant proteins across conditions in TMT experiment}
\usage{
groupComparisonTMT(
  data,
  contrast.matrix = "pairwise",
  moderated = FALSE,
  adj.method = "BH",
  remove_norm_channel = TRUE,
  remove_empty_channel = TRUE,
  save_fitted_models = FALSE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{data}{the output of \code{\link{proteinSummarization}} function. It is a list with data frames `FeatureLevelData` and `ProteinLevelData`}

\item{contrast.matrix}{Comparison between conditions of interests. 1) default is "pairwise", which compare all possible pairs between two conditions. 2) Otherwise, users can specify the comparisons of interest. Based on the levels of conditions, specify 1 or -1 to the conditions of interests and 0 otherwise. The levels of conditions are sorted alphabetically.}

\item{moderated}{TRUE will moderate t statistic; FALSE (default) uses ordinary t statistic.}

\item{adj.method}{adjusted method for multiple comparison. "BH" is default.}

\item{remove_norm_channel}{TRUE(default) removes "Norm" channels from protein level data.}

\item{remove_empty_channel}{TRUE(default) removes "Empty" channels from protein level data.}

\item{save_fitted_models}{logical, if TRUE, fitted models will be added to}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about 
data processing will be saved. 
If not provided, such a file will be created automatically.
If `append = TRUE`, has to be a valid path to a file.}
}
\value{
a list that consists of the following elements: 
(1) ComparisonResult: statistical testing results; 
(2) FittedModel: the fitted linear models
}
\description{
Tests for significant changes in protein abundance across conditions based on a family of linear mixed-effects models in TMT experiment.
Experimental design of case-control study (patients are not repeatedly measured) is automatically determined based on proper statistical model.
}
\examples{
data(input.pd)
# use protein.summarization() to get protein abundance data
quant.pd.msstats = proteinSummarization(input.pd,
                                       method="msstats",
                                       global_norm=TRUE,
                                       reference_norm=TRUE)

test.pairwise = groupComparisonTMT(quant.pd.msstats, moderated = TRUE)
head(test.pairwise$ComparisonResult)

# Only compare condition 0.125 and 1
levels(quant.pd.msstats$ProteinLevelData$Condition)

# Compare condition 1 and 0.125
comparison=matrix(c(-1,0,0,1),nrow=1)

# Set the nafmes of each row
row.names(comparison)="1-0.125"

# Set the column names
colnames(comparison)= c("0.125", "0.5", "0.667", "1")
test.contrast = groupComparisonTMT(data = quant.pd.msstats,
contrast.matrix = comparison,
moderated = TRUE)
head(test.contrast$ComparisonResult)

}
