% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_summarization_methods.R
\name{.summarizeTMT}
\alias{.summarizeTMT}
\title{Performs summarization for TMT data}
\usage{
.summarizeTMT(
  input,
  method,
  annotation,
  impute,
  max_quantile_censored,
  log_file_path
)
}
\arguments{
\item{input}{data.table}

\item{method}{"mstats"/"MedianPolish"/"LogSum"/"Median"}

\item{annotation}{data.table with run and channel annotation}

\item{impute}{only for method="msstats". TRUE (default) imputes missing 
values by Accelated failure model. FALSE uses minimum value to impute the 
missing value for each peptide precursor ion.}

\item{max_quantile_censored}{We assume missing values are censored. 
maxQuantileforCensored is Maximum quantile for deciding censored missing 
value, for instance, 0.999. Default is Null.}

\item{log_file_path}{path to a MSstats log file}
}
\value{
data.table
}
\description{
Performs summarization for TMT data
}
\keyword{internal}
