% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{PhilosophertoMSstatsTMTFormat}
\alias{PhilosophertoMSstatsTMTFormat}
\title{Convert Philosopher (Fragpipe) output to MSstatsTMT format.}
\usage{
PhilosophertoMSstatsTMTFormat(
  input,
  annotation,
  protein_id_col = "Protein",
  peptide_id_col = "Peptide.Sequence",
  Purity_cutoff = 0.6,
  PeptideProphet_prob_cutoff = 0.7,
  useUniquePeptide = TRUE,
  rmPSM_withfewMea_withinRun = TRUE,
  rmPeptide_OxidationM = TRUE,
  rmProtein_with1Feature = FALSE,
  summaryforMultipleRows = sum,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{input}{data.frame of `msstats.csv` file produced by Philosopher}

\item{annotation}{annotation with Run, Fraction, TechRepMixture, Mixture, Channel, 
BioReplicate, Condition columns or a path to file. Refer to the example 'annotation' for the meaning of each column. Channel column should be 
consistent with the channel columns (Ignore the prefix "Channel ") in msstats.csv file. Run column should be consistent with the Spectrum.File columns in msstats.csv file.}

\item{protein_id_col}{Use 'Protein'(default) column for protein name. 
'Master.Protein.Accessions' can be used instead to get the protein ID with single protein.}

\item{peptide_id_col}{Use 'Peptide.Sequence'(default) column for peptide sequence.
'Modified.Peptide.Sequence' can be used instead to get the modified peptide sequence.}

\item{Purity_cutoff}{Cutoff for purity. Default is 0.6}

\item{PeptideProphet_prob_cutoff}{Cutoff for the peptide identification probability. Default is 0.7. 
The probability is confidence score determined by PeptideProphet and higher values indicate greater confidence.}

\item{useUniquePeptide}{logical, if TRUE (default) removes peptides that are assigned for more than one proteins. 
We assume to use unique peptide for each protein.}

\item{rmPSM_withfewMea_withinRun}{TRUE (default) will remove the features that have 1 or 2 measurements within each Run.}

\item{rmPeptide_OxidationM}{TRUE (default) will remove the peptides including oxidation (M) sequence.}

\item{rmProtein_with1Feature}{TRUE will remove the proteins which have only 1 peptide and charge. Defaut is FALSE.}

\item{summaryforMultipleRows}{sum (default) or max - when there are multiple measurements for certain feature in certain run, 
select the feature with the largest summation or maximal value.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about 
data processing will be saved. 
If not provided, such a file will be created automatically.
If `append = TRUE`, has to be a valid path to a file.}

\item{...}{additional parameters to `data.table::fread`.}
}
\value{
`data.frame` of class `MSstatsTMT`
}
\description{
Convert Philosopher (Fragpipe) output to MSstatsTMT format.
}
