% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_MSstatsTMT.R
\docType{package}
\name{MSstatsTMT}
\alias{MSstatsTMT-package}
\alias{MSstatsTMT}
\title{MSstatsTMT: A package for protein significance analysis in shotgun mass spectrometry-based proteomic experiments with tandem mass tag (TMT) labeling}
\description{
A set of tools for detecting differentially abundant peptides and proteins in shotgun mass spectrometry-based proteomic experiments with tandem mass tag (TMT) labeling.
}
\section{functions }{

\itemize{
  \item \code{\link{PDtoMSstatsTMTFormat}} : generates MSstatsTMT required input format for Proteome discoverer output.
  \item \code{\link{MaxQtoMSstatsTMTFormat}} : generates MSstatsTMT required input format for MaxQuant output.
  \item \code{\link{SpectroMinetoMSstatsTMTFormat}} : generates MSstatsTMT required input format for SpectroMine output.
  \item \code{\link{OpenMStoMSstatsTMTFormat}} : generates MSstatsTMT required input format for OpenMS output.
  \item \code{\link{proteinSummarization}} : summarizes PSM level quantification to protein level quantification.
  \item \code{\link{dataProcessPlotsTMT}} : visualizes for explanatory data analysis.
  \item \code{\link{groupComparisonTMT}} : tests for significant changes in protein abundance across conditions.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{http://msstats.org/msstatstmt/}
  \item Report bugs at \url{https://groups.google.com/forum/#!forum/msstats}
}

}
\author{
\strong{Maintainer}: Devon Kohler \email{kohler.d@northeastern.edu}

Authors:
\itemize{
  \item Ting Huang \email{thuang0703@gmail.com}
  \item Meena Choi \email{mnchoi67@gmail.com}
  \item Mateusz Staniak \email{mtst@mstaniak.pl}
  \item Sicheng Hao \email{hao.sic@husky.neu.edu}
  \item Olga Vitek \email{o.vitek@northeastern.edu}
}

}
