% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{MSstatsLiP_model}
\alias{MSstatsLiP_model}
\title{MSstatsLiP_model}
\format{
A data.table consisting of 546 rows and 29 columns. Raw TrP data for use in testing
and examples.
}
\usage{
MSstatsLiP_model
}
\description{
Example output of groupComparisonLiP converter functions.
}
\details{
Example output of MSstatsLiP groupComparisonLiP function.
A list containing three data.tables corresponding to unadjusted LiP, TrP, and
adjusted LiP models. The data.tables contain the following columns:

\itemize{
\item ProteinName : Character column of protein names
\item PeptideSequence : Character column of peptide sequence name
\item Label : Condition comparison (Eg. Disease vs Control)
\item log2FC : Fold Change output results of model
\item SE : Standard error output of model
\item Tvalue : Tvalue output of model
\item DF : Degrees of Freedom output of model
\item pvalue : Pvalue result of model (unadjusted)
\item adj.pvalue : Adjusted Pvalue, generally BH adjustement is used
\item issue : Issue in model if any is reported
\item MissingPercentage : Percent of missing values in specific model
\item ImputationPercentage : Percent of values that needed to be imputed
\item fully_TRI: Boolean indicating if Peptide is fully tryptic
\item NSEMI_TRI: Boolean indicating if Peptide is NSEMI tryptic
\item CSEMI_TRI: Boolean indicating if Peptide is CSEMI tryptic
\item CTERMINUS: Boolean indicating if Peptide is CTERMINUS tryptic
\item NTERMINUS: Boolean indicating if Peptide is NTERMINUS tryptic
\item StartPos: Start position of peptide sequence
\item EndPos: End position of peptide sequence
\item FULL_PEPTIDE(LiP data only) : Combined protein name and peptide sequence.
Used for LiP data only because LiP is summarized to peptide level (not protein)
}
}
\examples{
head(MSstatsLiP_model$LiP.Model)
head(MSstatsLiP_model$TrP.Model)
head(MSstatsLiP_model$Adjusted.LiP.Model)

}
\keyword{datasets}
