% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeNetworks.R
\name{visualizeNetworks}
\alias{visualizeNetworks}
\title{Create visualization of network}
\usage{
visualizeNetworks(
  nodes,
  edges,
  pvalueCutoff = 0.05,
  logfcCutoff = 0.5,
  node_label_column = "id",
  main_targets = c()
)
}
\arguments{
\item{nodes}{dataframe of nodes consisting of columns
id (chararacter), pvalue (number), logFC (number)}

\item{edges}{dataframe of edges consisting of columns
source (character), target (character), interaction (character),
evidenceCount (number), evidenceLink (character)}

\item{pvalueCutoff}{p-value cutoff for coloring significant proteins.
Default is 0.05}

\item{logfcCutoff}{log fold change cutoff for coloring significant
proteins. Default is 0.5}

\item{node_label_column}{The column of the nodes dataframe to use as the 
node label.  Default is "id".  "hgncName" can be used for gene name.}

\item{main_targets}{character vector of main targets to stand-out with a 
different node shape.  Default is an empty vector c(). IDs of main targets
should match the column used by the node_label_column parameter.}
}
\value{
cytoscape visualization of subnetwork
}
\description{
Use results from INDRA to generate a visualization of the a network on
Cytoscape Desktop.  Note that the Cytoscape Desktop app must be open for
this function to work.
}
\examples{
input <- data.table::fread(system.file(
    "extdata/groupComparisonModel.csv",
    package = "MSstatsBioNet"
))
subnetwork <- getSubnetworkFromIndra(input)
visualizeNetworks(subnetwork$nodes, subnetwork$edges)

}
