% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnastring2kaks.R
\name{dnastring2kaks}
\alias{dnastring2kaks}
\title{dnastring2kaks}
\usage{
dnastring2kaks(
  cds,
  model = "Li",
  threads = 1,
  isMSA = TRUE,
  sgc = "1",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{cds}{\code{DNAStringSet} coding sequence alignment [mandatory]}

\item{model}{specify codon model either "Li" or "NG86" or
one of \code{KaKs_Calculator2} model "NG", "LWL", "LPB", "MLWL", "MLPB",
"GY", "YN", "MYN", "MS", "MA", "GNG", "GLWL", "GLPB", "GMLWL", "GMLPB",
"GYN", "GMYN" [default: Li]}

\item{threads}{number of parallel threads [default: 1]}

\item{isMSA}{cds \code{DNAStringSet} represents MSA [default: TRUE]}

\item{sgc}{standard genetic code (for KaKs Calculator models)
[default: 1]}

\item{verbose}{verbosity (for KaKs Calculator models) [default: FALSE]}

\item{...}{other codon alignment parameters}
}
\value{
A \code{data.frame} of \code{KaKs} values
}
\description{
This function calculates Ka/Ks (pN/pS)
for all combinations of a \code{DNAStringSet}.
If the sequences in the \code{DNAStringSet} are not a multiple-sequence
alignment, pairwise codon alignments can be calculated on the fly.
Models used and implemented according to
\emph{Li (1993)} (using \code{seqinr}) or
\emph{Nei and Gojobori (1986)} (own implementation) or models from
\code{KaKs_Calculator2} ported to \code{MSA2dist} with \code{Rcpp}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
#dnastring2kaks(hiv, model="Li")
hiv |> dnastring2kaks(model="Li")
#dnastring2kaks(hiv, model="NG86")
hiv |> dnastring2kaks(model="NG86")
#dnastring2kaks(hiv, model="NG86", threads=2)
hiv |> dnastring2kaks(model="NG86", threads=2)

## define three unaligned cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATGCATTGC")
cds3 <- Biostrings::DNAString("ATGCAATGC")
cds_sequences <- Biostrings::DNAStringSet(list(cds1, cds2, cds3))
names(cds_sequences) <- c("cds1", "cds2", "cds3")
## set isMSA to FALSE to automatically create pairwise codon alignments
#dnastring2kaks(cds_sequences, model="Li", isMSA=FALSE)
cds_sequences |> dnastring2kaks(model="Li", isMSA=FALSE)
}
\references{
"MS/MA/GNG/GLWL/GLPB/GMLWL/GMLPB/GYN:" Wang et al. (2010)
KaKs_Calculator 2.0: a toolkit incorporating
gamma-series methods and sliding window strategies.\emph{Genomics,
proteomics & bioinformatics.} \bold{8(1)}, 77-80.

"Li/LWL:" Li et al. (1985) A new method for estimating synonymous
and nonsynonymous rates of nucleotide substitution considering the relative
likelihood of nucleotide and codon changes. \emph{Mol. Biol. Evol.},
\bold{2(2)}, 150-174.

"Li/LPB:" Li (1993). Unbiased estimation of the rates of
synonymous and nonsynonymous substitution. Journal of molecular evolution,
36(1), pp.96-99.

"NG86/NG:" Nei and Gojobori. (1986) Simple methods for estimating
the numbers of synonymous and nonsynonymous nucleotide substitutions.
\emph{Mol. Biol. Evol.}, \bold{3(5)}, 418-426.

"LPB:" Pamilo and Bianchi. (1993) Evolution of the Zfx and Zfy
genes: Rates and interdependence between genes. \emph{Mol. Biol. Evol.},
\bold{10}, 271-281.

"MLWL/MLPB:" Tzeng et al. (2004). Comparison of three methods for
estimating rates of synonymous and nonsynonymous nucleotide substitutions.
\emph{Mol. Biol. Evol.}, \bold{21(12)}, 2290-2298.

"GY:" Goldman and Yang (1994). A codon-based model of nucleotide
substitution for protein-coding DNA sequences. \emph{Mol. Biol. Evol.},
\bold{11(5)} 725-736.

"YN:" Yang et al. (2000) Codon-substitution models for
heterogeneous selection pressure at amino acid sites. \emph{Genetics.}
\bold{155(1)}, 431-449.

"MYN:" Zhang et al. (2006). Computing Ka and Ks with a
consideration of unequal transitional substitutions.
\emph{BMC evolutionary biology}, \bold{6(1)}, 1-10.

"data(hiv):" Ganeshan et al. (1997) Human immunodeficiency virus
type 1 genetic evolution in children with different rates of development of
disease. \emph{J. Virology.} \bold{71(1)}, 663-677.

Wang et al. (2009). gamma-MYN: a new algorithm for estimating Ka
and Ks with consideration of variable substitution rates.
\emph{Biology Direct}, \bold{4(1)}, 1-18.
}
\seealso{
\code{\link[seqinr]{kaks}}
}
\author{
Kristian K Ullrich
}
