% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addregion2string.R
\name{addregion2string}
\alias{addregion2string}
\title{addregion2string}
\usage{
addregion2string(seq, region = NULL, append = TRUE)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}

\item{region}{\code{IRanges} object [mandatory]}

\item{append}{indicate if region should be appended or overwritten
[default: TRUE]}
}
\value{
An object of class \code{DNAStringSet} or \code{AAStringSet}
}
\description{
This function adds region information as an \code{IRanges}
object, \code{START} and \code{END} information, to a
\code{DNAStringSet} or an \code{AAStringSet} and puts them into the
\code{metadata} information.
This information can be used to restrict the distance calculation to
specific regions of the \code{DNAStringSet} or the \code{AAStringSet}.
}
\examples{
## load example sequence data
data(iupac, package="MSA2dist")
iupac.aa <- iupac |> cds2aa(shorten = TRUE)
## create region
region1 <- IRanges::IRanges(start=c(1,41), end=c(20,50))
## add region
iupac.aa <- iupac.aa |> addregion2string(region=region1)
#(iupac.aa |> slot("metadata"))$region
iupac.aa |> region()
## append region
region2 <- IRanges::IRanges(start=c(21), end=c(30))
iupac.aa <- iupac.aa |> addregion2string(region=region2)
#(iupac.aa |> slot("metadata"))$region
iupac.aa |> region()
## overwrite region
iupac.aa <- iupac.aa |> addregion2string(region=region2, append=FALSE)
#(iupac.aa |> slot("metadata"))$region
iupac.aa |> region()
## reduce by region
#iupac.aa.region <- iupac.aa |> string2region(region=
#    (iupac.aa |> slot("metadata"))$region)
iupac.aa.region <- iupac.aa |> string2region(region=
    region(iupac.aa))
#iupac.aa.region |> slot("metadata")
iupac.aa.region |> region()
}
\seealso{
\code{\link[MSA2dist]{addmask2string}},
\code{\link[MSA2dist]{addpop2string}},
\code{\link[MSA2dist]{addpos2string}}
}
\author{
Kristian K Ullrich
}
