% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessFunctions.R
\name{getAlpha}
\alias{getAlpha}
\title{return the fitted value for the transcription rate.}
\usage{
getAlpha(obj, by.factor = NULL, full = TRUE)
}
\arguments{
\item{obj}{the MpraObject to extract from, must be after model fitting}

\item{by.factor}{return a matrix of values, corresponding to the estimated
rates of transcription under different values of a factor included in the 
design. Value must be of these options:
NULL: (default) return only the intercept term, a single baseline rate for 
each enhancer
"all": will return the corresponding transcription rates for all values 
included in the model
factor name: must be a factor included in the RNA annotations and the rna 
design. Will return the corresponding rates for all values of the given 
factor}

\item{full}{if true, return rate of the full model (default), otherwise of
the reduced model (only applies if an LRT-based analysis was used)}
}
\value{
the estimate for transcription rate as fitted by the model
}
\description{
return the fitted value for the transcription rate.
}
\examples{
data <- simulateMPRA(tr = rep(2,10), da=c(rep(0,5), rep(1,5)), 
                     nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
obj <- analyzeComparative(obj, dnaDesign = ~ batch + barcode + condition, 
                              rnaDesign = ~ condition, reducedDesign = ~ 1)
## get alpha estimate for the two conditions
alpha <- getAlpha(obj, by.factor="condition")
}
