% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltMtfPrtIPL.R
\name{pltMtfPrtIPL}
\alias{pltMtfPrtIPL}
\title{Plot a heatmap of IPLs on proteins from consensus pathway submodules}
\usage{
pltMtfPrtIPL(fltmat, cldt, grphl, proteins = NULL)
}
\arguments{
\item{fltmat}{A matrix contains filterd IPL with rows as entity and
column as samples. This is the output from \code{fltByPerm()}.
Entity with NA value will be set to 0 and plotted as in
'normal' state.}

\item{cldt}{A data table with each row representing one clustering
result, and the first column denotes the number of
occurrences of a clustering result and the rest of columns
indicating each sample's cluster index. It is the output
of the \code{clSamp()} function. Only the most frequent
clustering result will be used to plot.}

\item{grphl}{A list of igraph objects representing consensus pathway
submodules. It is the output from \code{conMtf()}.}

\item{proteins}{A vector of proteins, of which IPLs to plot. Default: all
proteins that in both \code{grphl} and \code{fltmat}.}
}
\value{
A heatmap of IPLs o proteins from consensus pathway submodules
}
\description{
Plot a heatmap of IPLs on proteins from consensus pathway submodules
}
\examples{

fltmat <- system.file('extdata/pltSttKM/ipl.rds',package='MPAC') |> readRDS()
cldt <- system.file('extdata/pltMtfPrtIPL/cl.rds',package='MPAC')|> readRDS()
grphl <- system.file('extdata/pltMtfPrtIPL/grphl.rds',package='MPAC') |>
         readRDS()

pltMtfPrtIPL(fltmat, cldt, grphl, proteins=c('CD247', 'FASLG'))

}
