% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{MOSimulatorRegion-class}
\alias{MOSimulatorRegion-class}
\alias{SimRNAseq-class}
\alias{SimTF-class}
\alias{SimmiRNAseq-class}
\alias{SimChIPseq-class}
\alias{SimDNaseseq-class}
\alias{SimMethylseq-class}
\title{Virtual class containing general methods for simulators based on regions of
the chromosomes, like DNase-seq, ChIP-seq or Methyl-seq}
\description{
Virtual class containing general methods for simulators based on regions of
the chromosomes, like DNase-seq, ChIP-seq or Methyl-seq

Class to simulate RNA-seq data

Class to simulate transcription factor data

Class to simulate miRNA-seq

Class to simulate ChIP-seq data

Class to simulate DNase-seq data

Class to simulate Methyl-seq data.
}
\section{Slots}{

\describe{
\item{\code{locs}}{Vector containing the list of locations of the sites.}

\item{\code{locsName}}{Type of the site to simulate, only for debug.}

\item{\code{splitChar}}{Character symbol used to split identifiers in chr/start/end}

\item{\code{nCpG}}{numeric. Number of CpG sites to simulate.}

\item{\code{pSuccessMethReg}}{numeric. Probability of success in methylated region.}

\item{\code{pSuccessDemethReg}}{numeric. Probability of success in non methylated
region}

\item{\code{errorMethReg}}{numeric. Error rate in methylated region}

\item{\code{errorDemethReg}}{numeric. Error rate in methylated region}

\item{\code{nReadsMethReg}}{numeric. Mean number of reads in methylated region.}

\item{\code{nReadsDemethReg}}{numeric. Mean number of reads in non methylated
regions.}

\item{\code{phaseDiff}}{numeric. Phase difference in the differentially methylated
regions between two samples}

\item{\code{balanceHypoHyper}}{numeric. Balance of hypo/hyper methylation}

\item{\code{ratesHMMMatrix}}{numeric. Matrix of values that describes the exponential
decay functions that define the distances between CpG values.}

\item{\code{distType}}{character. Distribution used to generate replicates:}

\item{\code{transitionSize}}{numeric.}

\item{\code{PhiMeth}}{matrix. Transition matrix for CpG locations.}

\item{\code{PhiDemeth}}{matrix. <Not used>}

\item{\code{typesLocation}}{numeric. <Not used>}

\item{\code{returnValue}}{character. Selected column:}

\item{\code{betaThreshold}}{numeric. Beta threshold value used to calculate M values.}
}}

\keyword{internal}
