% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingMO.R
\name{plotModuleHeat}
\alias{plotModuleHeat}
\title{Plot a Heatmap of a Module by Omics}
\usage{
plotModuleHeat(
  moduleobj,
  moduleNumber,
  sortBy = NULL,
  paletteNames = NULL,
  additionalAnnotations = NULL,
  additionalPaletteNames = NULL,
  withSampleNames = TRUE,
  fontsize_row = 10,
  fontsize_col = 1,
  nrowsHeatmaps = 3,
  orgDbi = "org.Hs.eg.db",
  discr_prop_pca = 0.15,
  discr_prop_events = 0.05,
  ...
)
}
\arguments{
\item{moduleobj}{\code{MultiOmicsModule} class object}

\item{moduleNumber}{module number of interest}

\item{sortBy}{a covariate (omic) to sort by}

\item{paletteNames}{a palette containing three colors}

\item{additionalAnnotations}{optional additional sample annotations}

\item{additionalPaletteNames}{optional additional colors for annotations}

\item{withSampleNames}{show sample names}

\item{fontsize_row}{font size for row labels}

\item{fontsize_col}{font size for column labels}

\item{nrowsHeatmaps}{magnification respect to annotation of sample
(annotations take 1 row)}

\item{orgDbi}{a Dbi organism to be used. Default is \code{org.Hs.eg.db}}

\item{discr_prop_pca}{the minimal proportion to compute the PCA classes}

\item{discr_prop_events}{the minimal proportion to compute the event classes}

\item{...}{additional arguments passed to \code{guessInvolvement} function}
}
\value{
A heatmap of a pathway module (results of the module test)
}
\description{
It creates a heatmap of the most involved genes of each omic of a specific
module from a \code{MultiOmicsModule} object.
}
\examples{
data(multiOmics)
data(reactSmall)

survAnnot <- data.frame(
    status = multiOmics$status,
    days = multiOmics$days,
    row.names = colnames(multiOmics[[1]])
)

genesToUse <- row.names(multiOmics[[1]])

MOM_survival <- multiOmicsSurvivalModuleTest(multiOmics, reactSmall[[1]],
    survFormula = "Surv(days, status) ~", autoCompleteFormula = TRUE,
    useTheseGenes = genesToUse
)

plotModuleHeat(MOM_survival, 1,
    sortBy = c("mut", "expPC1", "status", "days"),
    additionalAnnotations = survAnnot,
    additionalPaletteNames = list(status = "teal", days = "violet"),
    withSampleNames = F
)

}
