% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiOmicsSurvivalTest.R
\name{multiOmicsSurvivalModuleTest}
\alias{multiOmicsSurvivalModuleTest}
\title{Compute Multi Omics Survival in Pathway Modules}
\usage{
multiOmicsSurvivalModuleTest(
  omicsObj,
  graph,
  survFormula = "Surv(days, status) ~",
  autoCompleteFormula = TRUE,
  useTheseGenes = NULL,
  pathName = NULL,
  robust = FALSE,
  include_from_annot = FALSE
)
}
\arguments{
\item{omicsObj}{Object of class \code{Omics}}

\item{graph}{a pathway in \code{graphNEL}, \code{Pathway} or geneset format}

\item{survFormula}{a character with the formula to compute survival}

\item{autoCompleteFormula}{logical. If TRUE autocomplete the \code{survFormula}
using all the available covariates}

\item{useTheseGenes}{vector of genes used to filter pathways}

\item{pathName}{title of the pathway. If NULL and graph is \code{Pathway},
\code{graph@title} is used as title}

\item{robust}{logical, whether the robust mode should be used
for cox model analysis}

\item{include_from_annot}{logical. If TRUE compute cox model analysis
using additional covariates from \code{colData}}
}
\value{
\code{MultiOmicsModules} object
}
\description{
Performs survival analysis using an \code{Omics} object. The pathway (graph) used
is decomposed in modules (cliques) using graph theory.
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOM_survival <- multiOmicsSurvivalModuleTest(multiOmics, reactSmall[[1]],
    survFormula = "Surv(days, status) ~", autoCompleteFormula = TRUE,
    useTheseGenes = genesToUse
)

}
