% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diggit.r
\name{rea}
\alias{rea}
\title{This function calculates an Enrichment Score of Association based on how the
features rank on the samples sorted by a specific gene}
\usage{
rea(eset, regulon, minsize = 1, maxsize = Inf, event.type = NA, verbose)
}
\arguments{
\item{eset}{Numerical matrix}

\item{regulon}{A list with genomic features as its names and samples as its 
entries, indicating presence of event}

\item{minsize}{The minimum number of events to use when calculating enrichment}

\item{maxsize}{The maximum number of events to use when calculating enrichment}

\item{event.type}{Type of event being analyzed}

\item{verbose}{whether to print extra progress statements}
}
\value{
A list containing two elements:
\describe{
\item{groups}{Regulon-specific NULL model containing the enrichment scores}
\item{ss}{Direction of the regulon-specific NULL model}
}
}
\description{
This function calculates an Enrichment Score of Association based on how the
features rank on the samples sorted by a specific gene
}
\keyword{internal}
