% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{plot_variance_explained_by_covariates}
\alias{plot_variance_explained_by_covariates}
\title{Plot variance explained by the smooth components of the model}
\usage{
plot_variance_explained_by_covariates(
  object,
  factors = "all",
  x = "view",
  y = "factor",
  split_by = NA,
  min_r2 = 0,
  max_r2 = NULL,
  compare_total = FALSE,
  legend = TRUE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object}

\item{factors}{character vector with a factor name(s), or numeric vector with the index(es) of the factor(s). Default is "all".}

\item{x}{character specifying the dimension for the x-axis ("view", "factor", or "group").}

\item{y}{character specifying the dimension for the y-axis ("view", "factor", or "group").}

\item{split_by}{character specifying the dimension to be faceted ("view", "factor", or "group").}

\item{min_r2}{minimum variance explained for the color scheme (default is 0).}

\item{max_r2}{maximum variance explained for the color scheme.}

\item{compare_total}{plot corresponding variance explained in total in addition}

\item{legend}{logical indicating whether to add a legend to the plot  (default is TRUE).}
}
\value{
A list of \code{\link{ggplot}} objects (if \code{compare_total} is TRUE) or a single \code{\link{ggplot}} object. 
Consider using cowplot::plot_grid(plotlist = ...) to combine the multiple plots that this function generates.
}
\description{
This function plots the variance explained by the smooth components (Gaussian processes) underlying the factors in MEFISTO across different views and groups, as specified by the user.
}
\details{
Note that this function requires the use of MEFISTO. 
To activate the functional MEFISTO framework, specify mefisto_options when preparing the training using \code{prepare_mofa}
}
\examples{
# load_model
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_variance_explained_by_covariates(model)

# compare to total variance explained
plist <- plot_variance_explained_by_covariates(model, compare_total = TRUE)
cowplot::plot_grid(plotlist = plist)
}
