% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{plot_enrichment_detailed}
\alias{plot_enrichment_detailed}
\title{Plot detailed output of the Feature Set Enrichment Analysis}
\usage{
plot_enrichment_detailed(
  enrichment.results,
  factor,
  alpha = 0.1,
  max.genes = 5,
  max.pathways = 10,
  text_size = 3
)
}
\arguments{
\item{enrichment.results}{output of \link{run_enrichment} function}

\item{factor}{string with factor name or numeric with factor index}

\item{alpha}{p.value threshold to filter out feature sets}

\item{max.genes}{maximum number of genes to display, per pathway}

\item{max.pathways}{maximum number of enriched pathways to display}

\item{text_size}{size of the text to label the top genes}
}
\value{
a \code{ggplot2} object
}
\description{
Method to plot a detailed output of the Feature Set Enrichment Analysis (FSEA). \cr
Each row corresponds to a significant pathway, sorted by statistical significance, and each dot corresponds to a gene. \cr
For each pathway, we display the top genes of the pathway sorted by the corresponding feature statistic (by default, the absolute value of the weight)
The top genes with the highest statistic (max.genes argument) are displayed and labelled in black. The remaining genes are colored in grey.
}
