% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_data_scatter}
\alias{plot_data_scatter}
\title{Scatterplots of feature values against latent factors}
\usage{
plot_data_scatter(
  object,
  factor = 1,
  view = 1,
  groups = "all",
  features = 10,
  sign = "all",
  color_by = "group",
  legend = TRUE,
  alpha = 1,
  shape_by = NULL,
  stroke = NULL,
  dot_size = 2.5,
  text_size = NULL,
  add_lm = TRUE,
  lm_per_group = TRUE,
  imputed = FALSE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{factor}{string with the factor name, or an integer with the index of the factor.}

\item{view}{string with the view name, or an integer with the index of the view. Default is the first view.}

\item{groups}{groups to plot. Default is "all".}

\item{features}{if an integer (default), the total number of features to plot. If a character vector, a set of manually-defined features.}

\item{sign}{can be 'positive', 'negative' or 'all' (default) to show only positive, negative or all weights, respectively.}

\item{color_by}{specifies groups or values (either discrete or continuous) used to color the dots (samples). This can be either: 
\itemize{
\item the string "group": dots are coloured with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the same of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
\item a dataframe with two columns: "sample" and "color"
}}

\item{legend}{logical indicating whether to add a legend}

\item{alpha}{numeric indicating dot transparency (default is 1).}

\item{shape_by}{specifies groups or values (only discrete) used to shape the dots (samples). This can be either: 
\itemize{
\item the string "group": dots are shaped with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the same of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
\item a dataframe with two columns: "sample" and "shape"
}}

\item{stroke}{numeric indicating the stroke size (the black border around the dots, default is NULL, inferred automatically).}

\item{dot_size}{numeric indicating dot size (default is 5).}

\item{text_size}{numeric indicating text size (default is 5).}

\item{add_lm}{logical indicating whether to add a linear regression line for each plot}

\item{lm_per_group}{logical indicating whether to add a linear regression line separately for each group}

\item{imputed}{logical indicating whether to include imputed measurements}
}
\value{
A \code{\link{ggplot}} object
}
\description{
Function to do a scatterplot of features against factor values.
}
\details{
One of the first steps for the annotation of factors is to visualise the weights using \code{\link{plot_weights}} or \code{\link{plot_top_weights}}.
However, one might also be interested in visualising the direct relationship between features and factors, rather than looking at "abstract" weights. \cr
A similar function for doing heatmaps rather than scatterplots is \code{\link{plot_data_heatmap}}.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_data_scatter(model)
}
