% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mofa.R
\name{create_mofa_from_df}
\alias{create_mofa_from_df}
\title{create a MOFA object from a data.frame object}
\usage{
create_mofa_from_df(df, extract_metadata = TRUE)
}
\arguments{
\item{df}{\code{data.frame} object with at most 5 columns: \code{sample}, \code{group}, \code{feature}, \code{view}, \code{value}. 
The \code{group} column (optional) indicates the group of each sample when using the multi-group framework.
The \code{view} column (optional) indicates the view of each feature when having multi-view data.}

\item{extract_metadata}{logical indicating whether to incorporate the extra columns as sample metadata into the MOFA object}
}
\value{
Returns an untrained \code{\link{MOFA}} object
}
\description{
Method to create a \code{\link{MOFA}} object from a data.frame object
}
\examples{
# Using an existing simulated data with two groups and two views
file <- system.file("extdata", "test_data.RData", package = "MOFA2")

# Load data (in long data.frame format)
load(file) 
MOFAmodel <- create_mofa_from_df(dt)
}
