% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{PartitionDensity}
\alias{PartitionDensity}
\title{Illustration of partition density}
\usage{
PartitionDensity(ADJ, PartitionSet)
}
\arguments{
\item{ADJ}{gene similarity matrix}

\item{PartitionSet}{vector indicates the partition label for genes}
}
\value{
partition density, defined as average density of all modules
}
\description{
Calculate the average density of all resulting modules from a partition. The 
density of each module is defined as the average adjacency of the module 
genes.
}
\examples{
data(synthetic)
ADJ1=abs(cor(datExpr1,use="p"))^10
dissADJ=1-ADJ1
hierADJ=hclust(as.dist(dissADJ), method="average" )
groups <- cutree(hierADJ, h = 0.8)
pDensity <- PartitionDensity(ADJ1,groups) 
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Langfelder, Peter, and Steve Horvath. "WGCNA: an R package for 
weighted correlation network analysis." BMC bioinformatics 9.1 (2008): 1.
}
\keyword{density}

